# qPCR analysis (finding yfp-only amplifications in IS- 0.1% galactose)
# get primer efficiency of different [primer] from slope of ng curve 

# primer  efficiency test (well F10-ancestral colony, with galK and rbsB primers, 5 orders of M dilutions)
# biorad qpcr machine BFB_1st floor; 60C 1 min.

#samplelist=c("B2a","B2y","B9a","B9y","A5a","A5y","F12" (=ANC CONTROL),"G1a","G1y")
#a=ancestral fluorescence, y=increased yfp fluorescence

######## read in data 
setwd("/Users/itomanek/Documents/promoter_evolution/experiments/qPCR/20190912_qPCR")
results_table= read.csv2("bella_ 2019-09-12 11-19-07_qPCR -  Quantification Summary_0.csv", header=TRUE, sep= ",",stringsAsFactors=FALSE)
results_table$Cq=as.numeric(results_table$Cq)

#change name: Starting.Quantity..SQ.  to nanogram (ng)
names(results_table)[8] <-c("ng")
results_table$ng <- as.numeric(results_table$ng) 
#delete well with no content("NTC" necessary for cycler software)
#results_table=results_table[-91,]
head(results_table)

## add well information - Target = galK,rbsB; Sample= Std,F10C,...
results_table$Target=c(replicate(12*3,"rbsB"),replicate(12*4,"galK"),replicate(12*1,"rbsB"))
results_table$Sample=c(replicate(6,c("Std","Std","Std","Std","Std","B2a","B2y","B9a","B9y","A5a","A5y","F12")),replicate(2,c("G1a","G1a","G1a","G1y","G1y","G1y","Na","Na","Na","Na","Na","Na")))
results_table$Sample[(2*12+1)]=c("Na") # first dilution of Std was done only in 2 replicas 
results_table$Sample[(5*12+1)]=c("Na") # =I=
results_table$ng=as.numeric(c(replicate(6,c(10,1,0.1,0.01,0.001,"Na","Na","Na","Na","Na","Na","Na")), replicate(2,(replicate(12,"Na")))))

library("ggplot2")

#plot data # overview (x-axis not too meaningful)
ggplot(data=results_table)+
  geom_point(aes(x=(as.numeric(row.names(results_table))), y=Cq, col=Sample, shape=Target),size=3)


#plot data #with ng information
ggplot(data=(subset(results_table, Sample !="Na")))+
  geom_point(aes(x=log10(ng), y=Cq, col=Target),size=2)+
  geom_smooth(data=subset(results_table, Target == "galK"&Sample=="Std"),aes(x=log10(ng), y=Cq, color=Sample),method = "lm",size=0.4, se = FALSE)+
  geom_smooth(data=subset(results_table, Target == "rbsB"&Sample=="Std"),aes(x=log10(ng), y=Cq, color=Sample),method = "lm",size=0.4, se = FALSE)


unique((results_table$Sample))
##### primer efficiency  
#(notes)
## amplified molecules should double every cycle:
##10-fold ng should give 3.3 times smaller Cq value (=100% efficiency)

#E =-1+10^(-1/slope).

#EFFICIENCY Std - galK dilution 1
Std_galK=subset(results_table, Sample == "Std" & Target == "galK" )
plot((Std_galK$ng),Std_galK$Cq) #nonlinear relationship
plot(log10(Std_galK$ng),Std_galK$Cq) 
Std_galK_lm=lm((Std_galK$Cq)~log10(Std_galK$ng))
abline(Std_galK_lm)
slope=Std_galK_lm$coefficients[2]
E =-1+10^(-1/slope)  #perfect would be 2 (double the template after 1 cycle)
E*100 #Efficiency  107.52%
E =10^(-1/slope)  #efficiency for Pfaffl method!
E_target=E #2.07

#EFFICIENCY Std - rbsB dilution 1
Std_rbsB=subset(results_table, Sample == "Std" & Target == "rbsB")
plot((Std_rbsB$ng),Std_rbsB$Cq) #nonlinear relationship
plot(log10(Std_rbsB$ng),Std_rbsB$Cq) 
Std_rbsB_lm=lm((Std_rbsB$Cq)~log10(Std_rbsB$ng))
abline(Std_rbsB_lm)
slope=Std_rbsB_lm$coefficients[2]
E =-1+10^(-1/slope)  #perfect would be 2 (double the template after 1 cycle)
E*100 #Efficiency  99.71%
E =10^(-1/slope)  #efficiency for Pfaffl method!
E_ref=E #2


###-->use Pfaffl method to calculate
##fold change taking into account primer efficiencies.

#####################################################

### Pfaffl 2001 method (take into account efficiency)
E =10^(-1/slope)  #efficiency for Pfaffl method!
E_target #galK efficiency
E_ref #rbsB efficiency

samplelist=c("B2a","B2y","B9a","B9y","A5a","A5y","F12","G1a","G1y")
ratios=c()
i=1
for (i in 1:length(samplelist)) { 
  galK_cq_sample = mean(subset(results_table, Sample == paste(samplelist[i]) & Target == "galK")$Cq)
  galK_cq_Std = mean(subset(results_table, Sample =="Std" & Target == "galK")$Cq)  #this is Std = ctr.
  rbsB_cq_Std = mean(subset(results_table, Sample =="Std" & Target == "rbsB")$Cq)
  rbsB_cq_sample = mean(subset(results_table, Sample == paste(samplelist[i]) & Target == "rbsB")$Cq)
  ratio=E_target^(galK_cq_Std - galK_cq_sample)/E_ref^(rbsB_cq_Std-rbsB_cq_sample)
  
  ratios[i]=ratio
}
ratios #fold change relative to Std ctr ("F12")
barplot(ratios,names.arg=samplelist)


#### ##### #####

#same for errorbars! (calculate ratio for )
### repeat Pffaffl method for individual wells
ratios_all=matrix(0,length(samplelist),3) 

for (i in 1:length(samplelist)) { 
  galK_cq_sample = (subset(results_table, Sample == paste(samplelist[i]) & Target == "galK")$Cq) #subset, not mean
  galK_cq_Std = mean(subset(results_table, Sample =="Std" & Target == "galK")$Cq)  #this is Std = ctr.
  rbsB_cq_Std = mean(subset(results_table, Sample =="Std" & Target == "rbsB")$Cq)
  rbsB_cq_sample = (subset(results_table, Sample == paste(samplelist[i]) & Target == "rbsB")$Cq)
  ratio=E_target^(galK_cq_Std - galK_cq_sample)/E_ref^(rbsB_cq_Std-rbsB_cq_sample)
  
  ratios_all[i,]=ratio
}
ratios_all #fold change relative to ctr ("7")

###
library(matrixStats)
ratiosds=rowSds(ratios_all)

df <- data.frame(bar = ratios, error = ratiosds)

foo <- barplot(df$bar,ylim=c(0,4),border=NA, names.arg=samplelist,col=c(1,3,1,3,1,3,1,1,3)) #arrows become errorbars stackoverflow
arrows(x0=foo,y0=df$bar+df$error,y1=df$bar-df$error,angle=90,code=3,length=0.1)
